% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sTest_one}
\alias{sTest_one}
\title{S test for Indirect Effect for a single mediator}
\usage{
sTest_one(alpha, x1, s11, df1, x2, s22, df2, x10 = 0, x20 = 0, s12 = 0)
}
\arguments{
\item{alpha}{Significance level for the test of significance}

\item{x1}{Numeric value of the estimated first effect of interest}

\item{s11}{Numeric value of the estimated first effect variance}

\item{df1}{Degrees of freedom for estimate x1}

\item{x2}{Numeric value of estimated second effect of interest}

\item{s22}{Numeric value of the estimated second effect variance}

\item{df2}{Degrees of freedom for estimate x2. Often the same as x1}

\item{x10}{Optional numeric value of alternative null hypothesis value for the first effect}

\item{x20}{Optional numeric value of alternative null hypothesis value for the second effect}

\item{s12}{Specification of covariance between x1 and x2. Typically 0, but may be non-zero in the prescence of missing data}
}
\value{
Boolean True/False value of whether the test rejects the Null hypothesis
}
\description{
This function takes 
the estimate of the effect of the independent variable on the mediator  
and the effect of the mediator on the effect as well as their variances and 
performs the S test. Alternative null hypothesis can be specified as well. 
Additionally, covariances of the parameters can be specified for cases 
involving missing data where the estimates may be correlated.
}
\note{
The function for the S-test does not incorporate interactions between the independent and mediating variables. 
The user must first calculate the mean and variance of the second product term to be used in the function call.
}
\examples{
sTest_one(0.05, .5, 1, 100, -.25, .1, 100)
}
\references{
Berger, Roger L. Likelihood Ratio Tests and Intersection-Union Tests. Advances in Statistical Decision Theory and Applications, 2011.
}
