% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.r
\docType{class}
\name{results_generator}
\alias{results_generator}
\title{R6 Class for Storing iglm Estimation and Simulation Results}
\description{
The `results` class stores estimation (`$estimate()`) and simulation (`$simulate()`) results.

This class is primarily intended for internal use within the `iglm`
framework but provides structured access to the results via the active
bindings of the main `iglm_object`.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{coefficients_path}}{(`matrix` or `NULL`) Read-only. The path of all estimated coefficients across iterations.}

\item{\code{samples}}{(`list` or `NULL`) Read-only. A list of simulated `iglm.data` objects (class `iglm.data.list`).}

\item{\code{stats}}{(`matrix` or `NULL`) Read-only. Matrix of summary statistics for simulated samples, which are an `mcmc` obect from `coda`.}

\item{\code{var}}{(`matrix` or `NULL`) Read-only. Estimated variance-covariance matrix for non-popularity coefficients.}

\item{\code{fisher_popularity}}{(`matrix` or `NULL`) Read-only. Fisher information matrix for popularity coefficients.}

\item{\code{fisher_nonpopularity}}{(`matrix` or `NULL`) Read-only. Fisher information matrix for non-popularity coefficients.}

\item{\code{score_popularity}}{(`numeric` or `NULL`) Read-only. Score vector for popularity coefficients.}

\item{\code{score_nonpopularity}}{(`numeric` or `NULL`) Read-only. Score vector for non-popularity coefficients.}

\item{\code{llh}}{(`numeric` or `NULL`) Read-only. Vector of log-likelihood values recorded during estimation.}

\item{\code{model_assessment}}{(`list` or `NULL`) Read-only. Results from model assessment (goodness-of-fit).}

\item{\code{estimated}}{(`logical`) Read-only. Flag indicating if estimation has been completed.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-results-new}{\code{results_generator$new()}}
\item \href{#method-results-set_model_assessment}{\code{results_generator$set_model_assessment()}}
\item \href{#method-results-gather}{\code{results_generator$gather()}}
\item \href{#method-results-save}{\code{results_generator$save()}}
\item \href{#method-results-resize}{\code{results_generator$resize()}}
\item \href{#method-results-update}{\code{results_generator$update()}}
\item \href{#method-results-remove_samples}{\code{results_generator$remove_samples()}}
\item \href{#method-results-plot}{\code{results_generator$plot()}}
\item \href{#method-results-print}{\code{results_generator$print()}}
\item \href{#method-results-clone}{\code{results_generator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-new"></a>}}
\if{latex}{\out{\hypertarget{method-results-new}{}}}
\subsection{Method \code{new()}}{
Creates a new `results` object. Initializes internal fields, primarily
setting up an empty matrix for the `coefficients_path` based on the
expected number of coefficients.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$new(size_coef, size_coef_popularity, file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size_coef}}{(integer) The number of non-popularity (structural)
coefficients in the model.}

\item{\code{size_coef_popularity}}{(integer) The number of popularity coefficients
in the model (0 if none).}

\item{\code{file}}{(character or `NULL`) If provided, loads the sampler state from
the specified .rds file instead of initializing from parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `results` object, initialized to hold results for a model
  with the specified dimensions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-set_model_assessment"></a>}}
\if{latex}{\out{\hypertarget{method-results-set_model_assessment}{}}}
\subsection{Method \code{set_model_assessment()}}{
Stores the results object generated by a model assessment (goodness-of-fit)
procedure within this `results` container.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$set_model_assessment(res)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{An object containing the model assessment results, expected to
have the class `iglm_model_assessment`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The `results` object itself (`self`), invisibly. Called for its
  side effect of storing the assessment results.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-gather"></a>}}
\if{latex}{\out{\hypertarget{method-results-gather}{}}}
\subsection{Method \code{gather()}}{
Gathers the current state of the `results` object into a list for saving
or inspection. This includes all internal fields such as coefficient paths,
samples, statistics, variance-covariance matrix, Fisher information,
score vectors, log-likelihood values, model assessment results, and
estimation status.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$gather()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing all the internal fields of the `results` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-save"></a>}}
\if{latex}{\out{\hypertarget{method-results-save}{}}}
\subsection{Method \code{save()}}{
Saves the current state of the `results` object to a specified file path
in RDS format. This allows for persisting the results for later
retrieval and analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$save(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) The file path where the results state should be
saved. Must be a valid character string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The `results` object itself (`self`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-resize"></a>}}
\if{latex}{\out{\hypertarget{method-results-resize}{}}}
\subsection{Method \code{resize()}}{
Resizes the internal storage for the coefficient paths to accommodate a
different number of coefficients. This is useful if the model structure
changes and the results object needs to be reset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$resize(size_coef, size_coef_popularity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size_coef}}{(integer) The new number of non-popularity coefficients.}

\item{\code{size_coef_popularity}}{(integer) The new number of popularity
coefficients.
@return The `results` object itself (`self`), invisibly.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-update"></a>}}
\if{latex}{\out{\hypertarget{method-results-update}{}}}
\subsection{Method \code{update()}}{
Updates the internal fields of the `results` object with new outputs,
typically after an estimation run (`$estimate()`) or simulation run
(`$simulate()`). Allows selectively updating components. Appends to
`coefficients_path` and `llh` if called multiple times after estimation.
Replaces `samples` and `stats`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$update(
  coefficients_path = NULL,
  samples = NULL,
  var = NULL,
  fisher_popularity = NULL,
  fisher_nonpopularity = NULL,
  score_popularity = NULL,
  score_nonpopularity = NULL,
  llh = NULL,
  stats = NULL,
  estimated = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coefficients_path}}{(matrix) A matrix where rows represent iterations
and columns represent all coefficients (non-popularity then popularity),
showing their values during estimation. If provided, appends to any
existing path.}

\item{\code{samples}}{(list) A list of simulated `iglm.data` objects (class `iglm.data.list`).
If provided, replaces any existing samples.}

\item{\code{var}}{(matrix) The estimated variance-covariance matrix for the
non-popularity coefficients. Replaces existing matrix.}

\item{\code{fisher_popularity}}{(matrix) The Fisher information matrix for
popularity coefficients. Replaces existing matrix.}

\item{\code{fisher_nonpopularity}}{(matrix) The Fisher information matrix for
non-popularity coefficients. Replaces existing matrix.}

\item{\code{score_popularity}}{(numeric) The score vector for popularity coefficients.
Replaces existing vector.}

\item{\code{score_nonpopularity}}{(numeric) The score vector for non-popularity
coefficients. Replaces existing vector.}

\item{\code{llh}}{(numeric) Log-likelihood value(s). If provided, appends to the
existing vector of log-likelihoods.}

\item{\code{stats}}{(matrix) A matrix of summary statistics from simulations,
where rows correspond to simulations and columns to statistics. Replaces
or extends the existing matrix and will be turned into a mcmc object from the `coda` package.}

\item{\code{estimated}}{(logical) A flag indicating whether these results come
from a completed estimation run. Updates the internal status.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The `results` object itself (`self`), invisibly. Called for its
  side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-remove_samples"></a>}}
\if{latex}{\out{\hypertarget{method-results-remove_samples}{}}}
\subsection{Method \code{remove_samples()}}{
Clears the stored simulation samples (`.samples`) and statistics (`.stats`) from the object,
resetting it to an empty list. This might be used to save memory or
before running new simulations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$remove_samples()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The `results` object itself (`self`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-plot"></a>}}
\if{latex}{\out{\hypertarget{method-results-plot}{}}}
\subsection{Method \code{plot()}}{
Generates diagnostic plots for the estimation results. Currently plots:
\itemize{
  \item The log-likelihood path across iterations.
  \item The convergence paths for popularity coefficients (if present).
  \item The convergence paths for non-popularity coefficients.
}
Optionally, can also trigger plotting of model assessment results if available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$plot(trace = FALSE, stats = FALSE, model_assessment = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trace}}{(logical) If `TRUE` (default), plot the trace plots of the estimation
(log-likelihood and coefficient paths). Requires
model to be estimated.}

\item{\code{stats}}{(logical) If `TRUE`, plots the normalized statistics from simulations.}

\item{\code{model_assessment}}{(logical) If `TRUE`, attempts to plot the results
stored in the `.model_assessment` field. Requires model assessment to
have been run and a suitable `plot` method for `iglm_model_assessment`
objects to exist. Default is `FALSE`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Requires estimation results (`private$.estimated == TRUE`) to plot
  convergence diagnostics. Requires model assessment results for the
  model assessment plots.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-print"></a>}}
\if{latex}{\out{\hypertarget{method-results-print}{}}}
\subsection{Method \code{print()}}{
Prints a concise summary of the contents of the `results` object,
indicating whether various components (coefficients path, variance matrix,
Fisher info, score, samples, stats, etc.) are available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments (currently ignored).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The `results` object itself (`self`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results-clone"></a>}}
\if{latex}{\out{\hypertarget{method-results-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{results_generator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
