% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image2data.R
\name{image2data}
\alias{image2data}
\title{Turn an image into data}
\usage{
image2data(
  path,
  type = "fill",
  scaling = "standardized",
  showplot = TRUE,
  reduce = 1,
  A = 1,
  R = c(0, 0.05),
  G = c(0, 0.05),
  B = c(0, 0.05),
  Grey = NULL,
  precision = 1,
  seed = NULL
)
}
\arguments{
\item{path}{Path to image file.}

\item{type}{Type of extraction of data. \code{type = "fill"} (default) returns the complete image as data whereas \code{type = "line"}
returns a specific range of color (default is black).}

\item{scaling}{Tranform the data to a specified scale. Three options are available : \code{"standardized", "original", "normalized")}. \code{scaling = "standardized"} converts data in a standardized form, \eqn{\mu = 0, \sigma = 1} (default); \code{scaling = "normalized"} converts data in a normalized form (to unit vectors); and \code{scaling = "original"} keeps the data untransformed.}

\item{showplot}{Show a preliminary plot of the data (default is \code{TRUE}).}

\item{reduce}{\code{reduce} can be a number \code{reduce > 0} or \code{reduce = "unique"}.  By default \code{reduce = 1}, so all pixels are returned. Specified values between \code{0} to \code{1} will return the corrresponding proportion of the pixels. Values over \code{1} will return the number of pixels (e.g., \code{reduce = 3} returns 3 data). If the chosen number is over the number of pixels, then random duplicates are added. If \code{reduce = "unique"} only unique elements (given a certain \code{precision}) are returned.}

\item{A}{Transparency, otherwise known as \eqn{\alpha}. By default, only non transparent (\code{A = 1}) values are returned. Semi-transparent colors (\code{0 < A < 1}) are supported. Values between the \code{A} to \code{1} range will be return. If \code{A = 0}, all pixels are returned regardless of transparency.}

\item{R, G, B}{Color to return with \code{type = "line"} (the default range is \code{c(0, .05)} for each, i.e., black). A single "range" of color can be used.}

\item{Grey}{Grey range to be returned with \code{type = "line"}. \code{Grey} overwrites \code{R, G, B} and behaves similarly. Default is \code{NULL}}

\item{precision}{Set precision of \code{reduce = "unique"}. Default is \code{1}. It can be any integer \code{>0}. Values closer to zero are less precised (less data), higher values are more precise (more data).}

\item{seed}{Set seed value for random pixel returned with \code{reduce}.}
}
\value{
A data frame with pixels as rows and columns are x and y coordinates and g is their color in hex (factors).
}
\description{
Extract an image file (\code{"png", "tiff", "jpeg", "bmp"}) and turn it into an enjoyable data set, pixels being rows (subjects) and columns (variables) being their coordinate positions (x and y axis) and their respective color (in hex codes).
}
\examples{
path <- system.file(file.path("extdata", "success.png"), package = "image2data")
image2data(path = path, type = "line")
image2data(path = path, type = "line", Grey = c(0,.50))

\dontrun{
image2data(path = file.choose())
}
}
