% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{implicitExpansion-package}
\alias{implicitExpansion-package}
\title{Implicit Expansion}
\description{
This package implements a feature known as "Broadcasting" in Python
(see e.g. \href{https://numpy.org/doc/stable/user/basics.broadcasting.html}{here})
and as "Implicit Expansion" in Matlab
(see e.g. \href{https://ch.mathworks.com/help/matlab/matlab_prog/compatible-array-sizes-for-basic-operations.html}{here}).
In operations involving multiple arguments of type \link{array}
(or \link{vector}, \link{matrix}, \link{list}) with mismatching dimensions, any argument is
repeated along its dimensions of size (exactly) 1, as often as necessary to
match the other argument(s).
}
\details{
Below are some examples that illustrate possible operations using implicit expansion.
For detailed explanations of the behavior, see the corresponding docs for
\href{https://numpy.org/doc/stable/user/basics.broadcasting.html}{Python}
and
\href{https://ch.mathworks.com/help/matlab/matlab_prog/compatible-array-sizes-for-basic-operations.html}{Matlab}.

Dimensions of size 0 are ok, as long as all other arrays are also
of size 0 or 1 in that dimension.

All arguments to an operation with implicit expansion are coerced to arrays
first.

Currently, all arguments to an operation with implicit expansion are expanded
to the full size of the output first, resulting in bad performance for very large arrays.

The package \code{rray} (
\href{https://github.com/r-lib/rray}{on GitHub},
\href{https://rray.r-lib.org/}{documentation},
currently archived on \href{https://CRAN.R-project.org/package=rray}{CRAN}
) provides similar functionality as part of complete a remodeling of the array object.
}
\examples{
x <- c(1,2,3)
y <- t(c(4,5))
x \%m+\% y
mmapply(sum, x, x, t(x))

m <- matrix(3*(1:12)^2, 3, 4)
cm <- t(colMeans(m))
m \%m-\% cm

summaries <- list(Max = max, Min = min, avg = mean)
data <- list(a = 1:5, b = 2:3, c = 20:12)
formatStrings <- array(c('\%.1f', '\%.3f'), c(1,1,2))
mmapply(function(f, d, s) sprintf(s, f(d)), summaries, t(data), formatStrings)

}
\seealso{
\code{\link{mmapply}}, \code{\link{BinaryOperators}}, \code{\link{expandArray}}, \code{\link{expandedDim}}, \code{\link{ArrayCreation}}, \code{\link{RowAndColumnVectors}}
}
