% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_indices.R
\name{order_cols}
\alias{order_cols}
\title{Order column indices}
\usage{
order_cols(ds, order_option, M = is.na(ds))
}
\arguments{
\item{ds}{A data frame}

\item{order_option}{This option defines the ordering of the indices. Possible
choices are "lowest_md_first", "highest_md_first", "increasing_index",
"decreasing_index".}

\item{M}{Missing data indicator matrix}
}
\value{
The ordered column indices of \code{ds} as a vector.
}
\description{
Order the indices of the columns of \code{ds} for imputation.
}
\examples{
ds <- data.frame(X = c(NA, NA, NA, 4), Y = rep(2, 4), Z = c(1, NA, NA, 4))
order_cols(ds, "highest_md_first")
}
