% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_donor.R
\name{predict_donor}
\alias{predict_donor}
\title{Prediction for donor-based imputation}
\usage{
predict_donor(
  ds_donors,
  ds,
  M = is.na(ds),
  i,
  donor_aggregation = "choose_random"
)
}
\arguments{
\item{ds_donors}{Data set with donors, normally generated by \code{\link[=model_donor]{model_donor()}}}

\item{ds}{The data set to be imputed. Must be a data frame with column names.}

\item{M}{Missing data indicator matrix}

\item{i}{Index of row of \code{ds} which should be imputed}

\item{donor_aggregation}{Type of donor aggregation. Can be one of
'choose_random' and 'average'.}
}
\value{
The imputation values for row \code{i}.
}
\description{
This function is intended to be used inside of \code{\link[=impute_unsupervised]{impute_unsupervised()}} as
\code{predict_fun}.
}
\examples{
set.seed(123)
ds_mis <- data.frame(X = rnorm(10), Y = rnorm(10))
ds_mis[2:4, 1] <- NA
ds_mis[4:6, 2] <- NA
# default for ds_donors and predict_donors
ds_donors <- model_donor(ds_mis)
predict_donor(ds_donors, ds_mis, i = 2)
predict_donor(ds_donors, ds_mis, i = 4)
# with partly_complete, knn and average of neighbors
ds_donors <- model_donor(
  ds_mis,
  i = 5, model_arg = list(selection = "knn_partly_complete_rows", k = 2)
)
ds_donors
predict_donor(ds_donors, ds_mis, i = 5, donor_aggregation = "average")
}
\seealso{
\code{\link[=model_donor]{model_donor()}}
}
