% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insertMVs.R
\name{insertMVs}
\alias{insertMVs}
\title{Generates missing values in data.}
\usage{
insertMVs(original, mean.THR, sd.THR, MNAR.rate)
}
\arguments{
\item{original}{complete data matrix containing all measurements}

\item{mean.THR, sd.THR}{- parameters of the threshold distribution which 
 controls the MVs rate (mean.THR should be initially set 
  such that the result of the initial thresholding, 
  in terms of no. of NAs, equals the desired total 
  missing data rate) 
- example: if one wants to generate 30% missing data
  mean.THR can be set as follows: 
  mean.THR = quantile(pepExprsData, probs = 0.3)
- sd.THR is usually set to a small value (e.g. 0.1)}

\item{MNAR.rate}{percentage of MVs which are missing not at random}
}
\value{
A list that contains the original complete data matrix, 
the data matrix with missing data and the 
percentage of missing data
}
\description{
this function generates missing data in a complete data matrix
}
