#ifndef MODRELASSO_HPP
#define MODRELASSO_HPP

#include <RcppArmadillo.h>

namespace modrelasso {

    using namespace arma;

    double pen(const colvec& adjwt, const colvec& wt) {
        colvec df = abs(1.0 - adjwt / wt);
        return sum(df);
    }

    colvec penGrd(const colvec& adjwt, const colvec& wt) {
        colvec df = sign(adjwt / wt - 1.0);
        return df / wt;
    }

}

#endif // MODRELASSO_HPP
