% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidental.R
\docType{package}
\name{incidental}
\alias{incidental}
\alias{incidental-package}
\title{incidental: A package for computing incidence curves from delayed case records.}
\description{
The incidental package provides an empirical Bayes estimator for fitting incidence curves
from a specified delay distribution, which describes the probability that a case will be
reported on day d after infection.
}
\section{Tutorial}{

To learn more about incidental, start with the vignettes:
`browseVignettes(package = "incidental")`
}

\section{Incidental functions}{

\code{\link{fit_incidence}}: main function for fitting incidence.

\code{\link{incidence_to_df}}: utility function to translate output of \code{\link{fit_incidence}} into a data frame.

\code{\link{plot}}: plots the results of \code{\link{fit_incidence}}.
}

\section{Data}{


\code{\link{spanish_flu_delay_dist}}: incidence to death delay distribution for the Spanish Flu.

\code{\link{spanish_flu}}: flu mortality data for Indiana, Kansas, and Philadelphia from 1919-09-01 through 1919-12-31.

\code{\link{covid_delay_dist}}: incidence to recorded cases, hospitalization, and death delay distribution for COVID-19.

\code{\link{covid_new_york_city}}: incidence to recorded cases, hospitalization, and death for New York City for COVID-19.
}

\author{
\strong{Maintainer}: Lauren Hannah \email{lauren_hannah@apple.com}

Authors:
\itemize{
  \item Andrew Miller \email{acmiller@apple.com}
  \item Nicholas Foti \email{nicholas_foti@apple.com}
  \item Joseph Futoma \email{jfutoma@apple.com}
}

Other contributors:
\itemize{
  \item Apple, Inc. \email{hai@apple.com} [copyright holder]
}

}
\keyword{internal}
