% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{publication_examples}
\alias{publication_examples}
\alias{rockette}
\alias{fatigue}
\alias{susquehanna}
\alias{pollution}
\title{Small data sets from different publications}
\format{
An object of class \code{numeric} of length 4.

An object of class \code{numeric} of length 10.

An object of class \code{numeric} of length 20.

An object of class \code{numeric} of length 20.
}
\source{
McCool, J.I., 1974. Inferential techniques for Weibull populations. Technical Report TR 74-0180, Wright Patterson Air Force Base, Ohio.

Rockette, H., 1974. Maximum Likelihood Estimation with the Weibull Model.

Dumonceaux, R. and Antle, C. E., 1973. Discrimination between the lognormal and the Weibull distributions. Technometrics, 15, 923-926.

Steen, P. J. and Stickler, D. J., 1976. A Sewage Pollution Study of Beaches from Cardiff to Ogmore. Report January 1976, Cardiff: Department of Applied Biology, UWIST.
}
\usage{
publication_examples

fatigue

susquehanna

pollution
}
\description{
Most data sets come from publications about parameter estimation in Weibull models.
See the references in the section "Source" below.
}
\details{
These small data sets are provided as numeric vectors.
\describe{
\item{\code{rockette}:}{Artificial sample of length 4 given by Rockette. The maximum likelihood function has two stationary points, none of them is the global maximum.}
\item{\code{fatigue}:}{Fatigue times of ten bearings of a specific type in hours.}
\item{\code{susquehanna}:}{Maximum flood levels (in millions of cubic feet per second) for the Susquehanna River of Harrisburg (Pennsylvania, USA) over 20 4-year periods.}
\item{\code{pollution}:}{Beach pollution levels in South Wales (measured in number of coliform per 100 ml) on 20 days over a 5-week period.}
}
}
\keyword{datasets}
