% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index0.R
\name{index0}
\alias{index0}
\alias{[.index0}
\alias{[<-.index0}
\alias{as.index0}
\alias{as.index1}
\alias{is.index0}
\alias{index_from_0}
\alias{print.index0}
\title{Zero-based indexing of vectors}
\source{
Partially inspired by this Stack Overflow answer:
\href{https://stackoverflow.com/a/49927880}{Zero based arrays/vectors in R}
}
\usage{
\method{[}{index0}(x, i, j, ...)

\method{[}{index0}(x, i, j, ...) <- value

as.index0(x)

as.index1(x)

is.index0(x)

index_from_0(x)

\method{print}{index0}(x, ...)
}
\arguments{
\item{x}{object from which to extract element(s) or in which to replace element(s)}

\item{i, j}{indices specifying elements to extract or replace. Starting from 1.}

\item{...}{other arguments passed to generic methods.}

\item{value}{typically an array-like \R object of a similar class as \code{x}.}
}
\value{
\code{as.index0} returns the input (typically a vector or matrix) unchanged except
for the addition of an \code{index0} class attribute, which enables the zero-based
indexing behaviour. Use \code{as.index1} to remove this class again, if present.

If \code{x} is a zero-indexed object with class \code{index0}, then \code{x[i]} returns an
appropriate subset of \code{x}. The returned subset is also zero-indexed.
\code{x[i] <- value} changes the \code{i}th element (effectively \code{(i+1)}th element in
ordinary R code) in place.

\code{is.index0(x)} returns \code{TRUE} if \code{x} is indexed from zero, otherwise \code{FALSE}.
}
\description{
Normally R is indexed from 1, but with the special \code{index0} class, you can
have vectors that are indexed from zero. Works both for subsetting (extraction)
and (sub-)assignment.
An \code{index0} object is just like a normal vector or matrix, but \code{x[i]} returns
or replaces the \code{(i+1)}th index.
}
\details{
Assign the class \code{index0} to a vector, using \code{as.index0()} or \code{index_from_0()},
then use the subset operators normally and they will be indexed from zero.
You can reverse the operation (reset to indexing from 1) with \code{as.index1()}
or by manually removing the \code{index0} class.
Character indices \emph{seem} to be unaffected. Be cautious with logical indices.
See examples.
}
\examples{
# Vectors
v <- as.index0(letters)
v[0:3]
v[c(0, 2)] <- c('zeroth', 'second')
v

# Matrices and arrays
m <- index_from_0(matrix(1:4, 2))
m[0, 1]
m[0, 1] <- 99
m

}
