% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOverDesMat.R
\name{makeOverDesMat}
\alias{makeOverDesMat}
\title{Construct the Overall Treatment or Block design Matrix}
\usage{
makeOverDesMat(design.df, effectNames)
}
\arguments{
\item{design.df}{a data frame containing the experimental design. Requires
every column be a \code{\link{factor}}.}

\item{effectNames}{a vector of character containing the labels of the
treatment or block terms in the model generated by the \code{\link{terms}}.}
}
\value{
A matrix where the rows correspond to the observation and columns
correspond to the overall combination of the treatment factors or the block
factors of the Phase 1 experiment.
}
\description{
Construct the treatment or block matrix of the smallest unit based from the
experimental design.
}
\details{
The main purpose this matrix is used in information decomposition. For the
factorial experiment, this matrix is typically the treatment design matrix
associated with the interaction effects, because the interaction effects
are the smallest unit for the treatment effects.

For the two-phase experiments, the same method of information decomposition
is used for the block effects of Phase 1 experiment in the stratum defined
from the block structure of the Phase 2 experiment. Hence, the block design
matrix of the smallest unit for the block effects of Phase 1 experiment can
also be constructed using this function.
}
\examples{

design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt, stringsAsFactors = TRUE )
})

trt.str = "Trt"
  
fT = terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE) 

trtTerm = attr(fT,"term.labels")
effectsMatrix = attr(fT,"factor") 
    
makeOverDesMat(design1, trtTerm)
       


}
\references{
John J, Williams E (1987). \emph{Cyclic and computer generated
Designs}. Second edition. Chapman & Hall.
}
\author{
Kevin Chang
}
