% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inpdfr_ANA_hist.R
\name{getSummaryStatsHISTO}
\alias{getSummaryStatsHISTO}
\title{Plot an histogram with the number of words excluding stop words}
\usage{
getSummaryStatsHISTO(
  wordF,
  getPlot = TRUE,
  mwidth = 800,
  mheight = 800,
  formatType = "png",
  ...
)
}
\arguments{
\item{wordF}{The data.frame containing word occurrences.}

\item{getPlot}{If \code{TRUE}, save the plot in the RESULTS directory.}

\item{mwidth}{The width of the plot in pixels.}

\item{mheight}{The height of the plot in pixels.}

\item{formatType}{The format for the output file ("eps", "pdf", "png", "svg", "tiff", "jpeg", "bmp").}

\item{...}{Additional arguments from \code{hist} function.}
}
\description{
Plot a histogram with the number of words excluding stop words using \code{\link[graphics]{hist}} function.
}
\examples{
data("wordOccuDF")
getSummaryStatsHISTO(wordF = wordOccuDF, getPlot = FALSE)
}
