% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_.R
\name{inspect_categories}
\alias{inspect_categories}
\title{Validate factor levels}
\usage{
inspect_categories(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_categories} does not return any output. There are two
possible outcomes:
\itemize{
\item The call is silent if \code{x} is eligible to be used as the levels of a factor.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_categories} checks if an object is eligible to be used
as the levels of a factor. This can be useful to validate inputs in
user-defined functions.
}
\details{
\code{inspect_categories} conducts a series of tests to check if \code{x}
is eligible to be used as the levels of a factor. Namely,
\code{inspect_categories} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is atomic.
\item \code{x} has an eligible data type (logical, integer, double, character).
\item There are \code{NA} or \code{NaN} values in \code{x}.
\item There are repeated values in \code{x}.
}
}
\examples{
# Calls that pass silently:
x1 <- 1:5
x2 <- c("yes", "no")
x3 <- c(TRUE, FALSE)
x4 <- factor(c("smoker", "non-smoker"))
x5 <- factor(c("yes", "no", "yes"))
inspect_categories(x1)
inspect_categories(x2)
inspect_categories(x3)
inspect_categories(x4)
inspect_categories(levels(x5))

# Calls that throw informative error messages:
y1 <- c(1, 1:5)
y2 <- c("yes", "no", "yes")
y3 <- factor(c("yes", "no", "yes"))
try(inspect_categories(y1))
try(inspect_categories(y2))
try(inspect_categories(y3))
try(mylist <- list(
  NULL, numeric(0),
  complex(1), list(10), NaN, NA
))
try(inspect_categories(mylist[[1]]))
try(inspect_categories(mylist[[2]]))
try(inspect_categories(mylist[[3]]))
try(inspect_categories(mylist[[4]]))
try(inspect_categories(mylist[[5]]))
try(inspect_categories(mylist[[6]]))
}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_data_dichotomous}} to validate dichotomous
data.
\item \code{\link[inspector]{inspect_data_categorical}} and
\code{\link[inspector]{inspect_data_cat_as_dichotom}} to validate categorical
data.
\item \code{\link[inspector]{inspect_par_bernoulli}} to validate
Bernoulli/Binomial proportions.
\item \code{\link[inspector]{inspect_par_multinomial}} to validate vectors of
Multinomial proportions.
\item \code{\link[inspector]{inspect_character}} to validate character vectors.
\item \code{\link[inspector]{inspect_character_match}} to validate character
vectors with predefined allowed values.
}
}
