% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_par_.R
\name{inspect_par_multinomial}
\alias{inspect_par_multinomial}
\title{Validate parameters for the Multinomial distribution}
\usage{
inspect_par_multinomial(x)
}
\arguments{
\item{x}{An arbitrary object.}
}
\value{
\code{inspect_par_multinomial} does not return any output.
There are two possible outcomes:
\itemize{
\item The call is silent if \code{x} is an eligible vector of Multinomial proportions.
\item An informative error message is thrown otherwise.
}
}
\description{
\code{inspect_par_multinomial} checks if an object is an eligible
vector of Multinomial proportions. This can be useful to validate inputs,
intermediate calculations or outputs in user-defined functions.
}
\details{
\code{inspect_par_multinomial} conducts a series of tests to check if
\code{x} is an eligible vector of Multinomial proportions. Namely,
\code{inspect_par_multinomial} checks if:
\itemize{
\item \code{x} is \code{NULL} or empty.
\item \code{x} is an atomic vector
\item \code{x} is numeric
\item \code{x} has \code{NA} or \code{NaN} values.
\item All elements of \code{x} are in the (0, 1) interval.
\item \code{x} sums to 1.
}
}
\examples{
# Calls that pass silently:
x1 <- c(0.5, 0.5)
x2 <- rep(1 / 5, 5)
inspect_par_multinomial(x1)
inspect_par_multinomial(x2)

# Calls that throw an informative error message:
mylist <- list(
  NULL, TRUE, factor(0.5, 0.5),
  matrix(c(0.5, 0.5)), c("0.5", "0.5"), list(0.5, 0.5),
  c(0.9, NA), c(0.9, NaN), numeric(0), NA, c(0.9, 0.6), c(-0.1, 0.9)
)
try(inspect_par_multinomial(mylist[[1]]))
try(inspect_par_multinomial(mylist[[2]]))
try(inspect_par_multinomial(mylist[[3]]))
try(inspect_par_multinomial(mylist[[4]]))
try(inspect_par_multinomial(mylist[[5]]))
try(inspect_par_multinomial(mylist[[6]]))
try(inspect_par_multinomial(mylist[[7]]))
try(inspect_par_multinomial(mylist[[8]]))
try(inspect_par_multinomial(mylist[[9]]))
try(inspect_par_multinomial(mylist[[10]]))
try(inspect_par_multinomial(mylist[[11]]))
try(inspect_par_multinomial(mylist[[12]]))
}
\seealso{
\itemize{
\item \code{\link[inspector]{inspect_par_bernoulli}} to validate parameters for
the Bernoulli/Binomial distribution.
\item \code{\link[inspector]{inspect_par_beta}} to validate parameters for the
Beta distribution.
\item \code{\link[inspector]{inspect_par_dirichlet}} to validate parameters for
the Dirichlet distribution.
\item \code{\link[inspector]{inspect_par_haldane}} to validate parameters for the
Haldane distribution.
\item \code{\link[inspector]{inspect_data_categorical}} and
\code{\link[inspector]{inspect_data_cat_as_dichotom}} to validate categorical
data.
\item \code{\link[inspector]{inspect_prob}} to check if an object is a numeric
vector of valid probability values.
}
}
