% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPopular.R
\name{getPopular}
\alias{getPopular}
\title{Returns 24 popular instagram posts information}
\usage{
getPopular(token, verbose = TRUE)
}
\arguments{
\item{token}{An OAuth token created with \code{instaOAuth}.}

\item{verbose}{If \code{TRUE} (default), outputs details about progress
of function on the console.}
}
\description{
\code{getPopular} retrieves up to 24 popular instagram posts
}
\details{
IMPORTANT: After June 1st, 2016 only applications that have passed permission
review by Instagram will be allowed to access data for users other than the
authenticated user. See  \url{https://www.instagram.com/developer/review/} 
for more information.
}
\examples{
\dontrun{
## See examples for instaOAuth to know how token was created.
## Downloading list of popular instagram posts
 load("my_oauth")
 popular_posts <- getPopular(token=my_oauth )
}

}
\author{
Jonne Guyt \email{j.y.guyt@uva.nl}
}

