% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{intervalsim}
\alias{intervalsim}
\title{Simulate a set of observed intervals}
\usage{
intervalsim(
  n = 500,
  mu = 200,
  sigma = 40,
  p = 0.3,
  fun = "gamma",
  trunc = c(0, 600),
  fpp = 0,
  n.ind = NA,
  sigma.within = NA
)
}
\arguments{
\item{n}{Number of simulated interval observations.}

\item{mu}{Mean arrival interval.}

\item{sigma}{Standard deviation of the arrival interval.}

\item{p}{Probability to not observe an arrival.}

\item{fun}{Assumed distribution for the intervals, one of "\code{normal}" or "\code{gamma}", corresponding
to the \link[stats]{Normal} and \link[stats]{GammaDist} distributions}

\item{trunc}{Observational range of intervals (intervals outside this range won't be observed)}

\item{fpp}{Baseline proportion of intervals distributed as a random poisson process with mean arrival interval \code{mu}}

\item{n.ind}{Number of intervals per group. Ignored without a numeric value for \code{sigma.within}.}

\item{sigma.within}{The within-group standard-deviation. When a numeric value is given for \code{sigma.within}, \code{sigma} denotes the total (within+between subject) standard deviation}
}
\value{
This function returns a dataframe containing the following:
\describe{
  \item{\code{interval}}{the simulated interval data}
  \item{\code{group_id}}{a group identifier}
}
}
\description{
Simulate a set of observed intervals
}
\details{
Simulates the observations process of arrival intervals.

The default is to not differentiate between
within- and between-group variance.

If both \code{n.ind} and \code{sigma.within} have numeric values, intervals are simulated
with separate within-group variation (\code{sigma.within}) and between-group variation,
for groups of size \code{n.ind}. Intervals belonging to the same group have:
\itemize{
 \item a within-group mean interval length that has been randomly drawn from a distribution with mean \code{mu}
 and between-group standard deviation \eqn{\sqrt{sigma^2 - sigma.within^2}}
 \item a within-group standard deviation in interval length equal to \code{sigma.within}
}
}
\examples{
# simulate observed intervals:
intervals=intervalsim(n=50,mu=200,sigma=40,trunc=c(0,600),fpp=0.1)
# check whether we retrieve the simulation parameters:
estinterval(goosedrop$interval)
}
