% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{plot.intRvals}
\alias{plot.intRvals}
\title{Plot an interval histogram and fit of intRvals object}
\usage{
\method{plot}{intRvals}(
  x,
  binsize = 20,
  xlab = "Interval",
  ylab = "Density",
  main = "Interval histogram and fit",
  line.col = "red",
  line.lwd = 1,
  ...
)
}
\arguments{
\item{x}{An intRvals class object}

\item{binsize}{Width of the histogram bins}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{main}{an overall title for the plot}

\item{line.col}{Color of the plotted curve for the model fit}

\item{line.lwd}{Line width of the plotted curve for the model fit}

\item{...}{Additional arguments to be passed to the low level \link[graphics]{hist} plotting function}
}
\value{
This function returns a list with data, corresponding to the model fit
}
\description{
Plot an interval histogram and fit of intRvals object
}
\examples{
data(goosedrop)
dr=estinterval(goosedrop$interval)
plot(dr)
plot(dr,binsize=10,line.col='blue')
}
