% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactionGraphs.R
\name{interactions3Way}
\alias{interactions3Way}
\title{Calculates 3-Way Interactions}
\usage{
interactions3Way(df, classAtt, speedUp = FALSE)
}
\arguments{
\item{df}{A discrete \code{data.frame}}

\item{classAtt}{A class column of the df (\code{string})}

\item{speedUp}{A (\code{boolean}) parameter. If \code{TRUE}, indicates
whether the pairs of attributes with Information Gain equal to zero (on the
4th decimal) should be pruned. This speeds up calculations for larger
datasets. By default it is turned off (i.e. set to \code{FALSE}).}
}
\value{
A list with a: 1) data frame with 3-way interactions, 2)list of 2-way
  interactions of the input attributes
}
\description{
Formula: \eqn{I(X;Y;C) = I(X,Y;C) - IG(X;C) - IG(Y;C)}, where \eqn{I(X;Y;C)}
is 3-way Interaction gain of the attributes \eqn{X} and \eqn{Y}, given the
context (i.e. class) attribute \eqn{C}. Hence, \eqn{I(X,Y;C)} is a joint
2-way interaction gain (i.e. Information Gain) of the attributes \eqn{X} and
\eqn{Y}, and \eqn{I(X;C)} and \eqn{I(Y;C)} are 2-way Interaction gains
(i.e. Information Gains) of the attributes \eqn{X} and \eqn{Y}, respectively.
}
\examples{
interactions3Way(golf, "Play")
\donttest{interactions3Way(golf, "Play", speedUp = TRUE)}
\donttest{interactions3Way(golf, "Play", speedUp = FALSE)}
}
