% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.pangloss.R
\name{read.pangloss}
\alias{read.pangloss}
\title{Read a file in the format used in the pangloss collection}
\usage{
read.pangloss(url, DOI = NULL, get.texts = TRUE, get.sentences = TRUE,
  get.words = TRUE, get.morphemes = TRUE)
}
\arguments{
\item{url}{a length one character vector with the url of the document to be imported}

\item{DOI}{an unique identifier}

\item{get.texts}{should the 'texts' data.frame be included in the result ?}

\item{get.sentences}{should the 'sentences' data.frame be included in the result ?}

\item{get.words}{should the 'words' data.frame be included in the result ?}

\item{get.morphemes}{should the 'morphemes' data.frame be included in the result ?}
}
\value{
a list with up to 5 slots corresponding to different units and named "texts", "sentences", "words", "morphemes".
Each slot contains a data frame where each line describe an occurrence of the corresponding unit.
}
\description{
The pangloss collection (http://lacito.vjf.cnrs.fr/pangloss/index_en.html) is a large collection of interlinearized texts.
}
\examples{
path <- system.file("exampleData", "FOURMI.xml", package="interlineaR")
corpus <- read.pangloss(path)
head(corpus$morphemes)
}
\references{
http://lacito.vjf.cnrs.fr/pangloss/index_en.html
}
