% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bonett.Seier.test.R
\name{Bonett.Seier.test}
\alias{Bonett.Seier.test}
\title{Bonett-Seier Test for Equality of Variability Measures}
\usage{
Bonett.Seier.test(x, y, alternative = c("two.sided", "less", "greater"),
  alpha = 0.05)
}
\arguments{
\item{x}{A vector specifying the first sample.}

\item{y}{A vector specifying the second sample.}

\item{alternative}{A character string specifying the alternative hypothesis; "two.sided" for two-tailed, "less" for left-tailed, and "greater" for right-tailed alternative hypothesis. The default option is "two.sided".}

\item{alpha}{A numeric specifying the significance level. The default option is 0.05.}
}
\value{
\item{Statistic}{The test statistic.}
\item{p.value}{The p-value.}
\item{Estimate}{The ratio of variability measures.}
\item{Lower.CI}{The lower bound of the confidence interval.}
\item{Upper.CI}{The upper bound of the confidence interval.}
}
\description{
Bonett-Seier t-test for comparing variability measures of two independent samples.
}
\examples{
 set.seed(123)
 x<-runif(10)
 y<-runif(15)
 Bonett.Seier.test(x,y,"two.sided",0.05)

}
