% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{kreutz2023.uc}
\alias{kreutz2023.uc}
\alias{Kreutz2023.uc}
\title{\insertCite{kreutz2023category;textual}{invitroTKdata} Ultracentrifugation Level-2 Data Set}
\format{
A level-2 data.frame with 2,955 rows and 23 variables: \describe{
\item{\code{Lab.Sample.Name}}{Sample description used in the laboratory}
\item{\code{Date}}{Date sample was acquired}
\item{\code{Compound.Name}}{Compound name}
\item{\code{DTXSID}}{DSSTox Substance Identifier (CompTox Chemicals Dashboard)}
\item{\code{Lab.Compound.Name}}{Compound as described in the laboratory}
\item{\code{Sample.Type}}{Type of UC sample}
\item{\code{Dilution.Factor}}{Number of times the sample was diluted}
\item{\code{Calibration}}{Identifier for mass spectrometry calibration -- usually the date}
\item{\code{Standard.Conc}}{Concentration of analytic standard (for calibration curve) (uM)}
\item{\code{UC.Assay.T1.Conc}}{Intended concentration of chemical intended in T1 sample (uM)}
\item{\code{ISTD.Name}}{Name of compound used as internal standard (ISTD)}
\item{\code{ISTD.Conc}}{Concentration of ISTD (uM)}
\item{\code{ISTD.Area}}{Peak area of internal standard (pixels)}
\item{\code{Series}}{Identier for replicate series of UC measurements}
\item{\code{Area}}{Peak area of analyte (target compound)}
\item{\code{Analysis.Method}}{General description of chemical analysis method}
\item{\code{Analysis.Instrument}}{Instrument(s) used for chemical analysis}
\item{\code{Analysis.Parameters}}{Parameters for identifying analyte peak (for example, retention time)}
\item{\code{Note}}{Any laboratory notes about sample}
\item{\code{Level0.File}}{Name of data file from laboratory that was used to compile level-0 data.frame}
\item{\code{Level0.Sheet}}{Name of "sheet" (for Excel workbooks) from which the laboratory data were read}
\item{\code{Response}}{Response factor (calculated from analyte and ISTD peaks)}
\item{\code{Verified}}{If "Y", then sample is included in the analysis. (Any other value causes the data to be ignored.)}
}
}
\usage{
kreutz2023.uc
}
\description{
Mass Spectrometry measurements of plasma protein binding measured by
ultracentrifugation (UC) for per- and poly-fluorinated alkyl substance
(PFAS) samples from experiments led by Dr.s Anna Kreutz and Barbara Wetmore.
}
\references{
\insertRef{howard2010plasma}{invitroTKdata}

\insertRef{kreutz2023category}{invitroTKdata}
}
\keyword{data}
