% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai.R
\name{aiPuxComposite}
\alias{aiPuxComposite}
\title{Estimate ai and average criterion scores for majority and minority groups.}
\usage{
aiPuxComposite(r_mat, y_col, x_col, dX, dY, wt_x, wt_y, sr, pct_minority)
}
\arguments{
\item{r_mat}{Super correlation matrix between the predictors and criteria.
This argument assumes that the predictors come first in the matrix.}

\item{y_col}{A vector of columns representing criterion variables.}

\item{x_col}{A vector of columns representing predictor variables.}

\item{dX}{A vector of d values for the predictors. These d values are expected
to have been computed in the direction of Majority - Minority.}

\item{dY}{A vector of d values for the criteria These d values are expected
to have been computed in the direction of Majority - Minority.}

\item{wt_x}{Weights for the predictors to form the overall composite predictor.}

\item{wt_y}{Weights for the criteria to form the overall composite criterion.}

\item{sr}{The percentage of the applicant population who are selected.}

\item{pct_minority}{The percentage of the applicant population who are part of
a given minority group.}
}
\value{
\itemize{
            \item{AI}{Adverse Impact}
            \item{Overeall_sr}{The overall selection ratio set by the user}
            \item{Majority_sr}{Majority Selection Rate}
            \item{Minority_sr}{Minority Selection Rate}
            \item{Majority_Standardized}{Predicted composite criterion score relative to the majority population}
            \item{Global_Standardized}{Predicted composite criterion score relative to the overall population} 
         }
}
\description{
Estimate ai and average criterion scores for majority and minority groups.
}
\examples{
# Example taken from De Corte, W. (2003)
R <- matrix(c(1.000, 0.170, 0.000, 0.100, 0.290, 0.160, 
              0.170, 1.000, 0.120, 0.160, 0.300, 0.260, 
              0.000, 0.120, 1.000, 0.470, 0.120, 0.200, 
              0.100, 0.160, 0.470, 1.000, 0.240, 0.250, 
              0.290, 0.300, 0.120, 0.240, 1.000, 0.170, 
              0.160, 0.260, 0.200, 0.250, 0.170, 1.000), 6, 6)

wt_x <- c(.244, .270, .039, .206) 
wt_y <- c(6, 2)
sr    <- 0.25
pct_minority <- .20

# Note that the d-values are reversed from what the CAIQS manual reports (see pg 4)
dX   <- c(1, 0.09, 0.09, 0.20)
dY   <- c(0.450, 0.0)

aiPuxComposite(R, 5:6, 1:4, dX, dY, wt_x, wt_y, sr, pct_minority)

# compare the output from predictAI with the output in the CAIQS manual on page 7 where SR = .250

}
\author{
Jeff Jones and Allen Goebl
}
\references{
De Corte, W., Lievens, F.(2003). A Practical procedure to estimate
the quality and the adverse impact of single-stage selection decisions.
\emph{International Journal of Selection and Assessment.}, 11(1), 87-95.
De Corte, W. (2003). Caiqs user's guide. http://allserv.rug.ac.be/~wdecorte/software.html
}

