% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{solveWt}
\alias{solveWt}
\title{Find r given arbitrary predictor weights}
\usage{
solveWt(r_mat, y_col, x_col, wt)
}
\arguments{
\item{r_mat}{A correlation matrix.}

\item{y_col}{A vector of columns representing criterion variables.}

\item{x_col}{A vector of columns representing predictor variables.}

\item{wt}{A vector of predictor weights or a list of multiple vectors.}
}
\value{
The correlation between the weighted predictor composite and criterion.
}
\description{
Find r given arbitrary predictor weights
}
\note{
This uses a simpler, faster version of the same formula used for fuse().
}
\examples{
library(iopsych)
#Get Data
data(dls2007)
r_mat <- dls2007[1:6, 2:7]

#Get weights
unit_wt <- c(1,1,1,1)
other_wt <- c(1,2,1,.5)
wt_list <- list(unit_wt, other_wt)

#Solve
solveWt(r_mat=r_mat, y_col=6, x_col=1:4, wt=unit_wt)
solveWt(r_mat=r_mat, y_col=6, x_col=1:4, wt=other_wt)
solveWt(r_mat=r_mat, y_col=6, x_col=1:4, wt=wt_list)
}
\author{
Allen Goebl and Jeff Jones
}

