% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_survey_data.R
\name{get_survey_data}
\alias{get_survey_data}
\title{get_survey_data}
\usage{
get_survey_data(survey_id, completion_status = "all")
}
\arguments{
\item{survey_id}{ID of the survey from which the collected data shall be
extracted.
6-digit integer.}

\item{completion_status}{'complete' = Return only complete cases;
'incomplete' = Return only incomplete cases; 'all' = Return both.}
}
\value{
A `data.frame` object containing the survey data.
Column names follow a dot-based naming scheme:
<group title>.<subquestion title>.
`NULL` if no data has been collected.
}
\description{
Get collected data from a specific survey on the connected
`LimeSurvey` instance.
Includes complete and incomplete cases!
Returns `NULL` if no data has been collected in this survey.
}
\examples{
# This example assumes a locally hosted `LimeSurvey` instance using a locally
# hosted MySQL server.
# On this `LimeSurvey` instance, there is a survey with the ID 123456.
\dontrun{
connect_to_limesurvey(
  api_url = 'https://localhost/index.php/admin/remotecontrol',
  limesurvey_username = 'admin',
  limesurvey_password = '1234admin',
  mysql_host = '127.0.0.1',
  mysql_port = 3306,
  mysql_dbname = 'limesurvey',
  mysql_table_prefix = '',
  mysql_username = 'lime',
  mysql_password = '1234lime'
)

df_data <- get_survey_data(123456)
}

}
