% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memT.R
\name{memT}
\alias{memT}
\title{Triangular membership function}
\usage{
memT(a, b, c, x)
}
\arguments{
\item{a}{Leftfooting value of the data set x}

\item{b}{Middle value of the data set x}

\item{c}{Rightfooting value of the data set x}

\item{x}{A data set in the form of document-term matrix}
}
\value{
Triangular membership values for the input data set x.
}
\description{
Triangular membership function with leftfooting, midvalue, rightfooting, and data set
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
a<-leftfootfinding(x,5)
b<-midvalue(x)
c<-rightfootfinding(x,5)
memT(a,b,c,x)
#       [,1]      [,2]      [,3]
#[1,] 0.3076923 0.4705882 0.5882353
#[2,] 0.5000000 0.5714286 0.4285714
#[3,] 0.8888889 0.9090909 0.8888889
#[4,] 0.1333333 0.1333333 0.1333333
}
