% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddi_read.R
\name{read_ipums_ddi}
\alias{read_ipums_ddi}
\title{Read metadata about an IPUMS microdata extract from a DDI codebook (.xml)
file}
\usage{
read_ipums_ddi(ddi_file, lower_vars = FALSE)
}
\arguments{
\item{ddi_file}{Path to a DDI .xml file downloaded from
\href{https://www.ipums.org/}{IPUMS}. See \emph{Downloading IPUMS files} below.}

\item{lower_vars}{Logical indicating whether to convert variable names to
lowercase. Defaults to \code{FALSE} for consistency with IPUMS conventions.}
}
\value{
An \link{ipums_ddi} object with metadata information.
}
\description{
Reads the metadata about an IPUMS extract from a
\href{https://ddialliance.org/introduction-to-ddi}{DDI codebook} into an
\link{ipums_ddi} object.

These metadata contains parsing instructions for the associated fixed-width
data file, contextual labels for variables and values in the data, and
general extract information.

See \emph{Downloading IPUMS files} below for information about downloading
IPUMS DDI codebook files.
}
\section{Downloading IPUMS files}{
The DDI codebook (.xml) file provided with IPUMS microdata extracts can be
downloaded through the IPUMS extract interface or (for some collections)
within R using the IPUMS API.

If using the IPUMS extract interface:
\itemize{
\item Download the DDI codebook by right clicking on the \strong{DDI} link in the
\strong{Codebook} column of the extract interface and selecting \strong{Save as...}
(on Safari, you may have to select \strong{Download Linked File As...}).
Be sure that the codebook is downloaded in .xml format.
}

If using the IPUMS API:
\itemize{
\item For supported collections, use \code{\link[=download_extract]{download_extract()}} to download a completed
extract via the IPUMS API. This automatically downloads both the DDI
codebook and the data file from the extract and
returns the path to the codebook file.
}
}

\examples{
# Example codebook file
ddi_file <- ipums_example("cps_00157.xml")

# Load data into an `ipums_ddi` obj
ddi <- read_ipums_ddi(ddi_file)

# Use the object to load its associated data
cps <- read_ipums_micro(ddi)

head(cps)

# Or get metadata information directly
ipums_var_info(ddi)

ipums_file_info(ddi)[1:2]

# If variable metadata have been lost from a data source, reattach from
# its corresponding `ipums_ddi` object:
cps <- zap_ipums_attributes(cps)

ipums_var_label(cps$STATEFIP)

cps <- set_ipums_var_attributes(cps, ddi$var_info)

ipums_var_label(cps$STATEFIP)
}
\seealso{
\code{\link[=read_ipums_micro]{read_ipums_micro()}}, \code{\link[=read_ipums_micro_chunked]{read_ipums_micro_chunked()}} and
\code{\link[=read_ipums_micro_yield]{read_ipums_micro_yield()}} to read data from IPUMS microdata extracts.

\code{\link[=ipums_var_info]{ipums_var_info()}} and \code{\link[=ipums_file_info]{ipums_file_info()}} to view metadata about an
\link{ipums_ddi} object.

\code{\link[=ipums_list_files]{ipums_list_files()}} to list files in an IPUMS extract.
}
