% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{ci.ICC1b}
\alias{ci.ICC1b}
\title{Confidence Interval of Intraclass Correlation Coefficient (ICC) under ANOVA Model 1B.}
\usage{
ci.ICC1b(ratings, conflev = 0.95)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{conflev}{This is the optional confidence level associated with the confidence interval. If not specified, the default value
will be 0.95, which is the most commonly-used valuee in the literature.}
}
\value{
This function returns a vector containing the following the lower confidence (lcb) and the upper confidence bound (ucb).
}
\description{
This function computes the lower and upper confidence bounds associated with the ICC under the one-factor ANOVA model
where each rater may rate a different group of subjects.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata3 dataset looks like
ci.ICC1b(iccdata1)
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 8, section 8.3.4, equations
8.3.5 and 8.3.6. Advanced Analytics, LLC.
}
