% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{icc2.inter.fn}
\alias{icc2.inter.fn}
\title{Intraclass Correlation Coefficients ICC(2,1) & ICCa(2,1) under the Random Factorial ANOVA Model with Interaction.}
\usage{
icc2.inter.fn(ratings)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (some duplicates are expected,
as some subject are assumed to have assigned multiple ratings) and each of the remaining columns is associated with a particular rater and
contains its numeric ratings.}
}
\value{
This function returns a list containing the following 12 values:
1. sig2s: the subject variance component. 2.sig2r: the rater variance component 3. sig2e: the error variance component.
4. sig2sr: the subject-rater interaction variance component. 5. icc2r: ICC as a measure of inter-rater relliability.
6. icc2a: ICC as a measure of intra-rater reliability. 7. n: the number of subjects. 8. r: the number of raters.
9. max.rep: the maximum number of ratings per subject. 10. min.rep: the minimum number of ratings per subjects.
11. M: the total number of ratings for all subjects and raters. 12. ov.mean: the overall mean rating.
}
\description{
This functions computes 2 ICC estimates for the inter-rater reliability and intra-rater reliability coefficients. It
requires some subjects to have multiple ratings and assumes the ANOVA model was specified with interaction.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
icc2.inter.fn(iccdata1)
coeff <- icc2.inter.fn(iccdata1)$icc2r #this only gives you the ICC coefficient
coeff
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} - Equation #9.2.3 of chapter 9, pages 231-232
(for the inter-rater reliability ICC(2,1)), and Equation #9.2.10 of chapter 9, page 236 (for the intra-rater reliability),
Advanced Analytics, LLC.
}
