% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_objects.R
\name{generate_item}
\alias{generate_item}
\title{Generate a random Item object}
\usage{
generate_item(model = "3PL", n_categories = 4, se = NULL, ...)
}
\arguments{
\item{model}{The model of the Item object.}

\item{n_categories}{For polytomous models, the number of categories for an
'item' object.}

\item{se}{The values of parameter standard errors, i.e. a list
  object with elements named as parameter names (excluding \code{"D"}
  parameter).

  If the value is \code{TRUE}, this function will generate standard error
  values from a uniform distribution between 0.05 and 0.75 for each parameter.}

\item{...}{Additional parameters passed to \code{item()} function.}
}
\value{
An \code{\link{Item-class}} object
}
\description{
Generate a random Item object
}
\examples{
# By default, a '3PL' model Item generated
generate_item()
# Generate item pools for other models
generate_item("Rasch")
generate_item("1PL")
generate_item("2PL")
generate_item("4PL")
# Polytomous items
generate_item("GRM")
generate_item("GPCM")
generate_item("PCM")
generate_item("GPCM2")
# Different number of categories
generate_item("GRM", n_categories = 2)
generate_item("GPCM", n_categories = 5)

# Generate standard errors for item parameters
generate_item(se = TRUE)

}
\author{
Emre Gonulates
}
