% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{crps}
\alias{crps}
\alias{crps.idr}
\alias{crps.data.frame}
\title{Continuous ranked probability score (CRPS)}
\usage{
crps(predictions, y)

\method{crps}{idr}(predictions, y)

\method{crps}{data.frame}(predictions, y)
}
\arguments{
\item{predictions}{either an object of class \code{idr} (output of
\code{\link{predict.idrfit}}), or a \code{data.frame} of numeric variables. In
the latter case, the CRPS is computed using the empirical distribution of
the variables in \code{predictions}.}

\item{y}{a numeric vector of obervations of the same length as the number of
predictions, or of length 1. In the latter case, \code{y} will be used for
all predictions.}
}
\value{
A vector of CRPS values.
}
\description{
Computes the CRPS of IDR or raw forecasts.
}
\details{
This function uses adapted code taken from the function \code{crps_edf} of
the \pkg{scoringRules} package.
}
\examples{
data("rain")

## Postprocess HRES forecast using data of 3 years

X <- rain[1:(3 * 365), "HRES", drop = FALSE]
y <- rain[1:(3 * 365), "obs"]

fit <- idr(y = y, X = X)

## Compute CRPS of postprocessed HRES forecast using data of the next 2 years
## (out-of-sample predictions)

data <- rain[(3 * 365 + 1):(5 * 365), "HRES", drop = FALSE]
obs <- rain[(3 * 365 + 1):(5 * 365), "obs"]
predictions <- predict(fit, data = data)
idrCrps <- crps(predictions, y = obs)

## Compare this to CRPS of the raw ensemble of all forecasts (high resolution,
## control and 50 perturbed ensemble forecasts)

rawData <- rain[(3 * 365 + 1):(5 * 365), c("HRES", "CTR", paste0("P", 1:50))]
rawCrps <- crps(rawData, y = obs)

c("idr_HRES" = mean(idrCrps), "raw_all" = mean(rawCrps))
}
\references{
Jordan A., Krueger F., Lerch S. (2018). "Evaluating Probabilistic
Forecasts with scoringRules." Journal of Statistical Software. Forthcoming.

Gneiting, T. and Raftery, A. E. (2007), 'Strictly proper scoring rules,
prediction, and estimation', Journal of the American Statistical Association
102(477), 359-378
}
\seealso{
\code{\link{predict.idrfit}}
}
