% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/york.R
\name{york_fit}
\alias{york_fit}
\title{Error-considering linear regression}
\usage{
york_fit(x, y, x_err, y_err, r = 0)
}
\arguments{
\item{x}{vector of x values.}

\item{y}{vector of y values. Has to be same the length as x.}

\item{x_err}{Error on the x values. Has to be same the length as x.}

\item{y_err}{Error on the y values. Has to be same the length as x.}

\item{r}{Correlation coefficient of x_err and y_err at each data point.
Default: \code{0} (independent errors).
Has to be same the length as x. Optional.}
}
\value{
A list with regression parameters:
\itemize{
\item slope and its standard error
\item intercept and its standard error
\item weights of the points (normalized to 1)
\item residual standard error (sigma)
\item R2
\item p-value (two-tailed t-test).
}
}
\description{
\code{york_fit()} calculates the regression parameters of
an error-considering linear regression.
}
\details{
Regression fitting method according to York et al. (2004).
The algorithm is described in the appendix of Wacker et al. (2014).
}
\section{Contributors}{

Julian Tödter
}

\examples{
york_fit(
  x = c(1, 2, 3),
  y = c(1.1, 1.9, 3.2),
  x_err = c(0.1, 0.2, 0.1),
  y_err = c(0.2, 0.1, 0.2))

}
\references{
York, D., Evensen, N. M., López Martínez, M., & De Basabe Delgado, J. (2004).
Unified equations for the slope, intercept, and
standard errors of the best straight line.
American Journal of Physics, 72(3), 367-375.
\doi{10.1119/1.1632486}

Wacker, U., Fiebig, J., Tödter, J., Schöne, B. R.,
Bahr, A., Friedrich, O., et al. (2014).
Empirical calibration of the clumped isotope paleothermometer using calcites
of various origins. Geochimica et Cosmochimica Acta, 141, 127-144.
\doi{10.1016/j.gca.2014.06.004}
}
