% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user.R
\name{count_to_tree}
\alias{count_to_tree}
\title{Calculate tree based on count matrix}
\usage{
count_to_tree(count, group = NULL, weight = 0)
}
\arguments{
\item{count}{a data frame containing numberic values of abundance or other
count.}

\item{group}{a vector of character containing the group information. The
length of the vector should be same with the count columns number. If using
unweighted clustring, should ignore this parameter.}

\item{weight}{a number specifying the weight size of the group information.
In most case, 1 is enough. If the value is between 0 and 1, it will make the
weight of group information weak. If the value is more than 1, it will make
the weight of group information strong.}
}
\value{
a phylo class object containing

\item{edge}{a vector of integers specifying edge id. The length of
vector is double of node number}

\item{edge.length}{a vector of numbers specifying edge length}

\item{tip.label}{a vector of character specifying the tip label}

\item{Nnode}{a number specifying the number of nodes}

\item{node.label}{a vector of character specifying the node label.
If the tree calculated from count matrix or other case, the node label will
generated by ape::makeNodeLabel function. And the Most Recent Common
Ancestors(MRCA) node will be named with weighted group information, if the
parameter group is not null.}
}
\description{
While we start analysis from count matrix not sequences
alignment, we could use clustering methods to get main tree in phylo object
class of output as Newick format file. If the samples or elements have group
information, we could use weighted clustering method to get a clear grouped
structure.
}
