# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @keywords internal
#' @rdname itp-internal
itp_cpp <- function(f, pars, a, b, ya, yb, epsilon, k1, k2, for_rk, inc) {
    .Call(`_itp_itp_cpp`, f, pars, a, b, ya, yb, epsilon, k1, k2, for_rk, inc)
}

#' Call a C++ function using an external pointer
#'
#' This function is used in \code{\link{plot.itp}} to plot a function and
#' the root estimated by \code{\link{itp}}.
#' @param x The main argument of the function.
#' @param pars A list of additional arguments to the function.  This may be an
#'   empty list.
#' @param xpsexp An external pointer to a C++ function.
#' @details See the
#' \href{https://gallery.rcpp.org/articles/passing-cpp-function-pointers/}{
#' Passing user-supplied C++ functions} article in the
#' \href{https://gallery.rcpp.org/}{Rcpp Gallery} for information.
#' @return A numeric scalar: the value of the C++ function evaluated at the
#'   input values \code{x} and \code{pars}.
#' @examples
#' lambert_ptr <- xptr_create("lambert")
#' res <- itp(lambert_ptr, c(-1, 1))
#'
#' # Value at lower limit
#' xptr_eval(-1, list(), lambert_ptr)
#'
#' # Value at upper limit
#' xptr_eval(1, list(), lambert_ptr)
#'
#' # Value at the estimated root
#' xptr_eval(res$root, list(), lambert_ptr)
#' @seealso \code{\link{xptr_create}} for creating an external pointer to a
#'   C++ function.
#' @export
xptr_eval <- function(x, pars, xpsexp) {
    .Call(`_itp_xptr_eval`, x, pars, xpsexp)
}

#' The ITP root-finding algorithm using C++
#'
#' Performs one-dimensional root-finding using the ITP algorithm of
#' Oliveira and Takahashi (2021). This function is equivalent to
#' \code{\link{itp}} but calculations are performed entirely using C++, and
#' the arguments differ slightly: \code{itp_c} has a named required argument
#' \code{pars} rather than \code{...} and it does not have the arguments
#' \code{interval}, \code{f.a} or \code{f.b}.
#' @param f An R function or an external pointer to a C++ function.  For the
#'   latter see the article
#'   \href{https://gallery.rcpp.org/articles/passing-cpp-function-pointers/}{
#'   Passing user-supplied C++ functions} in the
#'   \href{https://gallery.rcpp.org/}{Rcpp Gallery}. The function for which the
#'   root is sought.
#' @param f An external pointer to a C++ function that evaluates the function
#'   \eqn{f}.
#' @param pars A list of additional arguments to the function.  This may be an
#'   empty list.
#' @param a,b Numeric scalars. Lower (\code{a}) and upper \code{b} limits of
#'   the interval to be searched for a root.
#' @param epsilon A positive numeric scalar. The desired accuracy of the root.
#'   The algorithm continues until the width of the bracketing interval for the
#'   root is less than or equal to \code{2 * epsilon}.
#' @param k1,k2,n0 Numeric scalars. The values of the tuning parameters
#'   \ifelse{html}{\eqn{\kappa}\out{<sub>1</sub>}}{\eqn{\kappa_1}},
#'   \ifelse{html}{\eqn{\kappa}\out{<sub>2</sub>}}{\eqn{\kappa_2}},
#'   \ifelse{html}{\eqn{n}\out{<sub>0</sub>}}{\eqn{n_0}}.
#'   See the \strong{Details} section of \code{\link{itp}}.
#'
#'   The default value for \code{k1} in \code{\link{itp_c}} is set as
#'   the inadmissible value of \code{-1}
#'   (in reality \ifelse{html}{\eqn{\kappa}\out{<sub>1</sub>}}{\eqn{\kappa_1}}
#'   must be positive) as a device to set the same default value for \code{k1}
#'   as \code{\link{itp}}, that is, \code{k1 = 0.2 / (b - a)}.  If the input
#'   value of \code{k1} is less than or equal to 0 then, inside
#'   \code{\link{itp_c}}, \code{k1 = 0.2 / (b - a)} is set.
#' @details For details see \code{\link{itp}}.
#' @return An object (a list) of class \code{"itp"} with the same structure
#'   as detailed in the \strong{Value} section of \code{\link{itp}}, except
#'   that the attribute \code{f_name} is empty (equal to \code{""}).
#' @references Oliveira, I. F. D. and Takahashi, R. H. C. (2021). An Enhancement
#'   of the Bisection Method Average Performance Preserving Minmax Optimality,
#'   \emph{ACM Transactions on Mathematical Software}, \strong{47}(1), 1-24.
#'   \doi{10.1145/3423597}
#' @seealso \code{\link{print.itp}} and \code{\link{plot.itp}} for print and
#'   plot methods for objects of class \code{"itp"} returned from \code{itp_c}
#'   or \code{itp}.
#' @examples
#' wiki_ptr <- xptr_create("wiki")
#' wres <- itp_c(f = wiki_ptr, pars = list(), a = 1, b = 2, epsilon = 0.0005)
#' wres
#' plot(wres, main = "Wiki")
#' @export
itp_c <- function(f, pars, a, b, epsilon = 1e-10, k1 = -1.0, k2 = 2.0, n0 = 1.0) {
    .Call(`_itp_itp_c`, f, pars, a, b, epsilon, k1, k2, n0)
}

wiki_cpp <- function(x, pars) {
    .Call(`_itp_wiki_cpp`, x, pars)
}

neg_wiki_cpp <- function(x, pars) {
    .Call(`_itp_neg_wiki_cpp`, x, pars)
}

lambert_cpp <- function(x, pars) {
    .Call(`_itp_lambert_cpp`, x, pars)
}

trig1_cpp <- function(x, pars) {
    .Call(`_itp_trig1_cpp`, x, pars)
}

poly3_cpp <- function(x, pars) {
    .Call(`_itp_poly3_cpp`, x, pars)
}

linear_cpp <- function(x, pars) {
    .Call(`_itp_linear_cpp`, x, pars)
}

staircase_cpp <- function(x, pars) {
    .Call(`_itp_staircase_cpp`, x, pars)
}

log_cpp <- function(x, pars) {
    .Call(`_itp_log_cpp`, x, pars)
}

#' Create an external pointer to a C++ function
#'
#' This function is used in the \code{\link[itp:itp-package]{itp}} package to
#' create external pointers to the C++ functions used as examples to
#' illustrate the use of the function \code{\link{itp}}.  These pointers are
#' passed as the argument \code{f} to \code{\link{itp}}.  To create their own
#' examples the user will need to create their own C++ function(s) and a
#' function that is similar to \code{xptr_create}.
#'
#' @param fstr A string indicating the C++ function required.
#' @details See the vignette
#' \href{https://paulnorthrop.github.io/itp/articles/itp-vignette.html}{
#' Overview of the itp package} and the file
#' \href{https://raw.githubusercontent.com/paulnorthrop/itp/main/src/user_fns.cpp}{
#' user_fns.cpp} for information.
#'
#' The example C++ functions available in \code{itp} are: \code{"wiki"},
#' \code{"lambert"}, \code{"trig1"}, \code{"poly3"}, \code{"linear"},
#' \code{"warsaw"} and \code{staircase}.
#' @return The external pointer.
#' @seealso \code{\link{xptr_eval}} for calling a C++ function using an
#'   external pointer.
#' @examples
#' lambert_ptr <- xptr_create("lambert")
#' res <- itp(lambert_ptr, c(-1, 1))
#' @export
xptr_create <- function(fstr) {
    .Call(`_itp_xptr_create`, fstr)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_itp_RcppExport_registerCCallable`)
})
