% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.POEvaluation}
\alias{print.POEvaluation}
\title{Print summary information from model evaluation object (\code{POEvaluation}).}
\usage{
\method{print}{POEvaluation}(x, ...)
}
\arguments{
\item{x}{(\code{POEvaluation}) A presence-only evaluation object to be messaged.
It could be the return of function \code{\link{evaluate_po}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the most general and informative characteristics of
a model evaluation object.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

# Prepare data
data("occ_virtual_species")
obs_df <- occ_virtual_species \%>\% filter(usage == "train")
eval_df <- occ_virtual_species \%>\% filter(usage == "eval")
x_col <- "x"
y_col <- "y"
obs_col <- "observation"

# Format the observations
obs_train_eval <- format_observation(
  obs_df = obs_df, eval_df = eval_df,
  x_col = x_col, y_col = y_col, obs_col = obs_col,
  obs_type = "presence_only")

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

# With imperfect_presence mode,
mod <- isotree_po(
  obs_mode = "imperfect_presence",
  obs = obs_train_eval$obs,
  obs_ind_eval = obs_train_eval$eval,
  variables = env_vars, ntrees = 20,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

eval_train <- evaluate_po(mod$model,
  occ_pred = mod$pred_train$prediction,
  var_pred = na.omit(as.vector(mod$prediction[[1]])))

print(eval_train)
}

}
\seealso{
\code{\link{evaluate_po}}, \code{\link{plot.POEvaluation}}
}
