% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{runCplexAPI}
\alias{runCplexAPI}
\title{Running cplexAPI solver}
\usage{
runCplexAPI(model, lpdir, solver.options)
}
\arguments{
\item{model}{list of matrices and vectors defining the linear
programming problem.}

\item{lpdir}{input either CPX_MAX or CPX_MIN, which sets the LP
problem as a maximization or minimization problem.}

\item{solver.options}{list, each item of the list should
correspond to an option specific to the LP solver selected.}
}
\value{
a list of the output from CPLEX. This includes the
    objective value, the solution vector, and the optimization
    status (status of \code{1} indicates successful optimization).
}
\description{
This function solves the LP problem using the cplexAPI package. The
object generated by \code{\link{lpSetup}} is not compatible with
the \code{cplexAPI} functions. This function adapts the object to
solve the LP problem. See \code{\link{runGurobi}} for additional
error code labels.
}
