% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LittlewoodRichardson.R
\name{LRmult}
\alias{LRmult}
\title{Littlewood-Richardson rule for multiplication}
\usage{
LRmult(mu, nu, output = "dataframe")
}
\arguments{
\item{mu, nu}{integer partitions, given as vectors of decreasing integers}

\item{output}{the type of the output, \code{"dataframe"} or \code{"list"}}
}
\value{
This computes the expression of the product of the two Schur
  polynomials associated to \code{mu} and \code{nu} as a linear combination
  of Schur polynomials. If \code{output="dataframe"}, the output is a
  dataframe with two columns: the column \code{coeff} gives the coefficients
  of this linear combination, these are positive integers, and the column
  \code{lambda} gives the partitions defining the Schur polynomials of this
  linear combination as character strings, e.g. the partition
  \code{c(4, 3, 1)} is encoded by the character string \code{"[4, 3, 1]"}.
  If \code{output="list"}, the output is a list
  of lists with two elements. Each of these lists with two elements
  corresponds to a term of the linear combination: the first element,
  named \code{coeff}, is the coefficient, namely the Littlewood-Richardson
  coefficient \eqn{c^{\lambda}_{\mu,\nu}}, where \eqn{\lambda} is the
  integer partition given in the second element of the list, named
  \code{lambda}, which defines the Schur polynomial of the
  linear combination.
}
\description{
Expression of the product of two Schur polynomials as a linear
  combination of Schur polynomials.
}
\examples{
library(jack)
mu <- c(2, 1)
nu <- c(3, 2, 1)
LR <- LRmult(mu, nu, output = "list")
LRterms <- lapply(LR, function(lr) {
  lr[["coeff"]] * SchurPol(3, lr[["lambda"]])
})
smu_times_snu <- Reduce(`+`, LRterms)
smu_times_snu == SchurPol(3, mu) * SchurPol(3, nu) # should be TRUE
}
