% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{alpha2col}
\alias{alpha2col}
\title{set R color alpha value}
\usage{
alpha2col(x, alpha = 1, maxValue = 1, ...)
}
\arguments{
\item{x}{R compatible color, either a color name, or hex value, or
a mixture of the two. Any value compatible with \code{\link[grDevices]{col2rgb}}.}

\item{alpha}{numeric alpha transparency to use per x color. alpha is
recycled to length(x) as needed.}

\item{maxValue}{numeric maximum value to return, useful when the downstream
alpha range should be 255. By default maxValue=1 is returned.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{character} vector of R colors, with alpha values.
}
\description{
Define the alpha transparency per R color
}
\examples{
withr::with_par(list("mfrow"=c(2,2)), {
for (alpha in c(1, 0.8, 0.5, 0.2)) {
   nullPlot(plotAreaTitle=paste0("alpha=", alpha),
      doMargins=FALSE);
   usrBox(fill=alpha2col("yellow",
      alpha=alpha));
}
})

}
\seealso{
Other jam color functions: 
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
