% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-size.R
\name{asSize}
\alias{asSize}
\title{convert numeric value or R object to human-readable size}
\usage{
asSize(
  x,
  digits = 3,
  abbreviateUnits = TRUE,
  unitType = "bytes",
  unitAbbrev = gsub("^(.).*$", "\\\\1", unitType),
  kiloSize = 1024,
  sep = " ",
  ...
)
}
\arguments{
\item{x}{\code{numeric} vector, class \code{object_size} which is converted
to \code{numeric}, any other R object is converted to a single \code{numeric}
value using \code{utils::object.size()}.}

\item{digits}{\code{integer} number of digits used by \code{base::format()} when
formatting the number to create a character string}

\item{abbreviateUnits}{\code{logical}, default TRUE,  whether to print
abbreviated units, for example using k, M, G, T, P instead of
kilo, mega, Giga, Tera, Peta, respectively.}

\item{unitType}{\code{character} string indicating the base unit of measure,
by default "bytes". Note that trailing "s" is removed when the number
is singular.}

\item{unitAbbrev}{\code{character} string indicating an abbreviated base unit,
by default it uses the first character from \code{unitType.}}

\item{kiloSize}{\code{numeric}, default 1024,  number of base units when
converting from to one "kilo" base unit. For computer-based size
such as file size and object size, this value is 1024.
For other purposes, such as scientific or monetary numbers, this
value should usually be 1000.}

\item{sep}{\code{delimiter} used between the numeric value and the unit,
default " ".}

\item{...}{other parameters passed to \code{base::format()}.}
}
\value{
\code{character} vector representing human-friendly size,
based upon the \code{kiloSize} argument to determine whether to
report byte (1024) or scientific (1000) units.
}
\description{
convert numeric value or R object to human-readable size
}
\details{
This function returns human-readable size based upon \code{numeric} input.
Alternatively, when input is any other R object, it calls
\code{utils::object.size()} to produce a single \code{numeric} value which is then
used to produce human-readable size.

The default behavior is to report computer size in bytes, where
1024 is considered "kilo", however argument \code{kiloSize} can be
used to produce values where \code{kiloSize=1000} which is suitable
for monetary and other scientific values.
}
\examples{
asSize(c(1, 10,2010,22000,52200))
#> "1 byte"   "10 bytes" "2 kb"     "21 kb"    "51 kb"

# demonstration of straight numeric units
asSize(c(1, 100, 1000, 10000), unitType="", kiloSize=100)

}
\seealso{
Other jam string functions: 
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
