\name{WB}
\alias{WB}
\title{Branch Dry Weight (WB)}
\description{
The Branch Dry Weight (WB) is estimated using the stem diameter at breast height (DBH) in centimeter unit and tree height (H) in meter unit, based on the allometric equations from the journal *"Allometric Equations for Estimating Above-Ground Biomass and Leaf Area of Planted Teak (Tectona grandis) Forests Under Agroforestry Management in East Java, Indonesia"* (Purwanto & Shiba, 2006). The equation has a coefficient of determination R^2 of 0.979, reflecting a strong fit. This parameter is crucial for biomass estimation and is most accurate when applied to trees in the same region as the original study, East Java, Indonesia. All measurements for DBH are in centimeter, tree height is in meter, and the output weight is in kilograms.}
\arguments{
  \item{d}{(numeric) The stem diameter at breast height (DBH) in centimeters.}
  \item{h}{(numeric) The tree height in meters.}
}
\usage{
WB(d, h)
}
\value{
The estimated branch dry weight (WB) in kilograms.
}
\examples{
# Example: Estimating WB using DBH = 30 cm and tree height = 15 m
d <- 30  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WB_result <- WB(d, h)
print(WB_result)

# Example: Handling missing or zero values
d <- NA  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WB_result <- WB(d, h)
print(WB_result)  # Should return NA because DBH is NA

d <- 0  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WB_result <- WB(d, h)
print(WB_result)  # Should return 0 because DBH is 0
}