% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jcalendaR-utils.R
\name{number_kyureki.month}
\alias{number_kyureki.month}
\alias{existence_leap.month}
\alias{era.name}
\title{jcalendaR-utils}
\usage{
number_kyureki.month(
  kyureki.year,
  kyureki.month,
  era = c("south", "north", "east", "heishi", "kyoto", "non")
)

existence_leap.month(
  kyureki.year,
  existence = c("logical", "number"),
  era = c("south", "north", "east", "heishi", "kyoto", "non")
)

era.name(era = c("south", "north", "east", "heishi", "kyoto"))
}
\arguments{
\item{kyureki.year}{The number of years in the Kyureki calendar to check.}

\item{kyureki.month}{The number of strings of months in the Kyureki calendar to check.}

\item{era}{Whether the Gengo of the Japanese calendar is the Southern or Northern dynasty system, the system used in the Kanto region, the Heike, and Kyoto respectively, or no era names.}

\item{existence}{Whether to return the existence of a leap month as a theoretical type or as a leap month number.}
}
\value{
* `number_kyureki.month()` returns a numeric vector.

* `existence_leap.month()` returns a numeric vector or logical vector.

* `era.name()` returns a string vector that the era names of the corresponding year in this package.
}
\description{
This is a set of utility functions related to the Kyureki calendar. `number_kyureki.month()` checks how many days there were in a month by specifying the number of years and months in the Kyureki calendar. `existence_leap.month()` checks if there was a leap month in a year by entering the number of years in the Kyureki calendar.
`era.name()` will output the era names of the corresponding year in this package.
}
\examples{
existence_leap.month("\u660e\u6cbb2")
number_kyureki.month("\u660e\u6cbb2", 1)

}
\references{
The data for the Kyureki calendar and era names refer to the following data.

manakai/data-locale \url{https://github.com/manakai/data-locale}
}
