% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{convert_cols}
\alias{convert_cols}
\title{Convert Multiple Columns of a \code{data.frame}

All at once conversion of a \code{data.frame} from current column types to
alternates.}
\usage{
convert_cols(d, cast)
}
\arguments{
\item{d}{A \code{data.frame} that needs to have specific columns converted.}

\item{cast}{A \verb{string vector} containing either:
\code{"n"} (numeric), \code{"c"} (character), or \code{"f"} (factor).}
}
\value{
A \code{data.frame} with converted column types.
}
\description{
Convert Multiple Columns of a \code{data.frame}

All at once conversion of a \code{data.frame} from current column types to
alternates.
}
\examples{

n = 100

st = sample(LETTERS, n, replace = TRUE)
sr = sample(letters, n, replace = TRUE)
num = rnorm(n)

d = data.frame(x = st, y = num, z = sr, stringsAsFactors = FALSE)

# Convert all columns

o = convert_cols(d,c("f", "c", "f"))

# Convert a subset
d[, c(1, 3)] = convert_cols(d[, c(1, 3)], c("f", "f"))
}
