% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_field.R
\name{replace_field_journal}
\alias{replace_field_journal}
\alias{replace_field_author}
\title{Replace field \code{journal} with built-in data sets and user provided data sets.}
\usage{
replace_field_journal(dt, abbrtable_user)

replace_field_author(
  dt,
  author.connect = c("nothing", "\\\\\\\\&", "&", "and")
)
}
\arguments{
\item{dt}{is data.table, the object returned by the function \code{read_bib2dt}.}

\item{abbrtable_user}{data.table, the object returned by the function \code{add_abbrtable}.}

\item{author.connect}{is character, what symbols are used to connect multiple authors, \code{'nothing','\\\\&',
'&', 'and'}, where \code{'nothing'} stand for do nothing(default).}
}
\value{
data.table

data.table
}
\description{
Replace field \code{journal} with built-in data sets and user provided data sets.

Replace field \code{author}
}
\examples{
csvpath <- system.file("extdata", "myabbr.csv", package = "journalabbr", mustWork = TRUE)
abbrtable_user <- add_abbrtable(file = csvpath, header = FALSE, sep = ",")
colnames(abbrtable_user)

file <- system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
dt <- read_bib2dt(file)

newdt <- replace_field_journal(dt, abbrtable_user)
newdt1 <- replace_field_author(dt, author.connect = "and")
newdt2 <- replace_field_author(dt, author.connect = "&")

}
