% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jtdmCV.R
\name{jtdmCV}
\alias{jtdmCV}
\title{K-fold cross validation predictions and goodness of fit metrics}
\usage{
jtdmCV(m, K = 5, sample = 1000, partition = NULL)
}
\arguments{
\item{m}{a model fitted with \code{jtdm_fit}}

\item{K}{The number of folds of the K-fold cross validation}

\item{sample}{Number of samples from the posterior distribution. Since we sample from the exact posterior distribution, the number of samples is relative lower than MCMC samplers. As a rule of thumb, 1000 samples should provide correct inference.}

\item{partition}{A partition of the dataset specified by the user. It is a vector (whose length are the number of sites), where each element specifies the fold index of the site.}
}
\value{
A list containing:
   \item{Pred}{Sample from the posterior predictive distribution in cross validation. It is an array where the first dimension is the number of sites in Xnew, the second is the number of traits modeled and the third the number of MCMC samples. NULL if FullPost=FALSE. }
   
   \item{PredMean}{Posterior mean of posterior predictive distribution in cross validation. }
   
   \item{Predq975,Predq025}{97.5\% and 0.25\% posterior quantiles of the posterior predictive distribution in cross validation. NULL if FullPost=FALSE. }
   
   \item{R2}{R squared of predictions in cross validation. }
   
   \item{RMSE}{Root square mean error between  squared of predictions in cross validation.}
}
\description{
Run K-fold cross validation predictions of the model m on a specified dataset.
}
\examples{
data(Y)  
data(X)  
m = jtdm_fit(Y=Y, X=X, formula=as.formula("~GDD+FDD+forest"), sample = 1000)  
# Run 3-fold cross validation on m
pred = jtdmCV(m, K = 5, sample = 1000)
}
