% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jubilee-adj-fault-line-method.R
\name{jubilee.adj_fault_line}
\alias{jubilee.adj_fault_line}
\title{Adjust the time series by fault lines}
\usage{
jubilee.adj_fault_line(fraction, ts, fl, months = 1)
}
\arguments{
\item{fraction}{numeric, representing year in fraction convention.}

\item{ts}{numeric, time series to be adjusted, typically it is \code{log.cape10} or \code{log.cape20}.}

\item{fl}{the fault line matrix. See \code{jubilee.std_fault_line()} for more detail.
If it is provided as character string,
it will be looked up as the name of data set in the standard fault line library.
If it is provided as numeric array, it will be converted to a matrix.}

\item{months}{interval in months to ramp up the fault line. Default is 1.}
}
\value{
numeric, ts adjusted by fault lines
}
\description{
This utility is used to adjust the time series by the provided fault lines.
}
\examples{
\dontrun{
  repo <- jubilee.repo(online=FALSE)
  dj <- jubilee(repo@ie, 45, 10)@reg.dtb
  dj$log.cape10.adj <- jubilee.adj_fault_line(dj$fraction, dj$log.cape10, "r_nom_f10_5ftr_4fl")
}

}
\author{
Stephen H. Lihn
}
\keyword{model}
