% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jfunctions.R
\name{J_admissible}
\alias{J_admissible}
\title{Admissible Rank Transformations of Eichner & Stute (2013)}
\usage{
J_admissible(u, cc = sqrt(5))
}
\arguments{
\item{u}{Numeric vector.}

\item{cc}{Numeric constant, defaults to \eqn{\sqrt 5}.}
}
\value{
Vector of same length and mode as \code{u}.
}
\description{
This is just a wrapper for the functions \code{\link{J1}}, \code{\link{J2}},
and \eqn{u -> \sqrt 3 * (2u - 1)} which implement the admissible
transformations for the three cases for \eqn{c}. For mathematical
details see eq. (15.16) and (15.17) in Eichner (2017) and/or Eichner &
Stute (2013).
}
\details{
Basically, for \code{cc} in \eqn{[\sqrt(5/3), \sqrt 5]}:

\code{J_admissible(u, cc)} = \code{J1(u, cc)} if \code{cc} \eqn{< \sqrt 3},

\code{J_admissible(u, cc)} = \code{J2(u, cc)} if \code{cc} \eqn{> \sqrt 3},
and

\code{J_admissible(u, cc)} = \code{sqrt(3) * (2*u - 1)} if \code{cc}
\eqn{= \sqrt 3}.
}
\note{
The admissible rank transformations require \eqn{c} to
      be in \eqn{[\sqrt(5/3), \sqrt 5]}. If \code{cc} does
      not satisfy this requirement a warning (only) is issued.
      The default \code{cc = sqrt(5)}, i.e., \eqn{c = \sqrt 5},
      yields the optimal rank transformation.
}
\examples{
\donttest{
par(mfrow = c(1, 2), mar = c(3, 3, 0.5, 0.5), mgp = c(1.7, 0.7, 0))
example(J1)
example(J2)
}

}
\seealso{
\code{\link{J1}} and \code{\link{J2}}.
}
