% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.R
\name{bw_t}
\alias{bw_t}
\title{Bandwidth selection for the transformation kernel estimator}
\usage{
bw_t(udata)
}
\arguments{
\item{udata}{data.}
}
\value{
A \verb{2 x 2} bandwidth matrix.
}
\description{
The bandwidth is selected by a rule of thumb. It approximately minimizes
the MISE of the Gaussian copula on the transformed domain. The usual normal
reference matrix is multiplied by 1.25 to account for the higher variance
on the copula level.
}
\details{
The formula is
\deqn{1.25  n^{-1 / 6}  \hat{\Sigma}^{1/2},}
where \eqn{\hat{Sigma}} is empirical covariance matrix of the transformed
random vector.
}
\references{
Nagler, T. (2014).
Kernel Methods for Vine Copula Estimation.
Master's Thesis, Technische Universitaet Muenchen,
\url{https://mediatum.ub.tum.de/node?id=1231221}
}
