% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointInspection.R
\name{pointInspection}
\alias{pointInspection}
\title{Get data from ECMWF ERA_Interim}
\usage{
pointInspection(years, points, var, prefix = "", path = "~",
  parallel = FALSE)
}
\arguments{
\item{years}{years to retrieve data for}

\item{points}{are lat/lon coordinates of points (e.g. stations)}

\item{var}{variable to retrieve}

\item{prefix}{string starting netcdf file name}

\item{path}{folder path where netcdf files are stored}

\item{parallel}{Bolean, if TRUE parallel jobs are allowed}
}
\value{
time series variable
}
\description{
Get data from ECMWF ERA_Interim
}
\details{
Possible variables names are: "t2m" (2m temperature, in K), "u10" (10 metres wind U component, in m/s), "v10" (10 metres wind V component, in m/s), "tp" (total precipitation, in m), "blh" (boundary layer height, in m), "ssr" (surface net solar radiation, in W/m2s).
}
\examples{
# pointInspection(years = 1981:2014, points, var = "t2m")

}

