% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyplayer.R
\name{contract}
\alias{contract}
\title{Group the Chosen Players in a Network}
\usage{
contract(adj.matrix, nodes, method = c("min", "max", "union", "add"))
}
\arguments{
\item{adj.matrix}{Matrix indicating the adjacency matrix of the network.
The inputted adjacency matrix for the diffusion centrality should
be properly transfomred to the probability interpretation.}

\item{nodes}{Integer indicating the column index of the chosen player
in the adjacenncy matrix.}

\item{method}{Indication of which grouping criterion should be used.\cr
\code{method="min"} indicates the "minimum" criterion (edge values as distances).\cr
\code{method="max"} indicates the "maximum" criterion (edge values as non-cummulative strengths).\cr
\code{method="add"} indicates the "addition" criterion (edge values as cummulative strengths).\cr
\code{method="union"} indicates the "union" criterion (edge values as probability).\cr
The default is "min". See details for examples.}
}
\value{
A new adjacency matrix after contracting the chosen nodes (named
\code{set}).
}
\description{
\code{contract} combines selected nodes into one large pseudo-node and provides a reduced network.
}
\details{
Minimum Criterion: the edge value between a group and an outside node
is measured as the minimal value among all the (nonzero) edge values between
any node in the group and the outside node. Suggested if edge values are
interpreted as distances.\cr
\emph{Example: suppose node A to C has distance 2 and B to C has distance 1,
then according to the minimum criterion, the distance between C and
the merged set AB is 1. Note that if B and C are not connected,
the algorithm takes the distance between A and C to describe
the distance between AB and C.}

Maximun Criterion: the edge value between a group and an outside node
is measured as the maximal value among all the (nonzero) edge values between
any node in the group and the outside node. Suggested if edge values are
interpreted as non-cummulative strengths. \cr
\emph{Example: we keep using the above example, but the figure now indicates
the strength of tie. According to the maximum criterion, the strength of tie
between AB and C is 2.}

Addition Criterion: the edge value between a group and an outside node
is measured as the sum of all the edge values between any node in the group
and the outside node. Suggested if edge values are as cummulative strengths. \cr
\emph{Example: according to the addition criterion, the strength of tie between
AB and C is 3}

Union Criterion: the edge value between a group and an outside node is measured
as the probability that there is at least one path connecting the group with
the outside node. Suggested if edge values are as probability. \cr
\emph{Example: suppose A has probability 0.2 to reach C and B has probability
0.5 to reach C, then C can be reached from merged AB with probability
1-(1-0.2)*(1-0.5)=0.6 according to the union criterion.}
}
\examples{
# Create a 5x5 weighted and directed adjacency matrix, where edge values
# represent the strength of tie
W <- matrix(
  c(0,1,3,0,0,
    0,0,0,4,0,
    1,1,0,2,0,
    0,0,0,0,3,
    0,2,0,0,0),
    nrow=5, ncol=5, byrow = TRUE)

# If the strength is believed to be non-accumulative for a group of nodes,
# it is proper to use the "maximum" criterion to contract node 2 and 3
contract(W,c(2,3),"max")

# Transform the edge value to probability interpretaion
P <- W *0.2

# Contract node 2 and 3 using the "union" criterion as it is proper for
# probability matrix input
contract(P,c(2,3),"union")

}
\references{
An, Weihua and Yu-Hsin Liu (2016). "keyplayer: An R Package for Locating Key Players in Social Networks."
\emph{The R Journal}, 8(1): 257-268.\cr
}
\seealso{
\code{\link{kpcent}};
\code{\link{kpset}}
}
\author{
Weihua An \email{weihua.an@emory.edu}; Yu-Hsin Liu \email{ugeneliu@meta.com}
}
