% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_functions.R
\name{utils_EM}
\alias{utils_EM}
\title{utils_EM a function to estimate the parameters `m_0` , `mm`, `pp` through 
an Expectation-Maximization (EM) method}
\usage{
utils_EM(param, kappaOpt, Y, Tps, N, scalingC)
}
\arguments{
\item{param}{list, see initial parameter list in \code{kfino_fit}}

\item{kappaOpt}{numeric, truncation setting for initial parameters' 
optimization, default 7}

\item{Y}{character, name of the numeric variable to predict in the
data.frame datain}

\item{Tps}{character, time column name in the data.frame datain, a 
numeric vector.
Tvar can be expressed as a proportion of day in seconds}

\item{N}{numeric, length of the numeric vector of Y values}

\item{scalingC}{numeric, scaling constant. To be changed if the function is 
not able to calculate the likelihood because the number of data is large}
}
\value{
a list:
\describe{
 \item{m0}{numeric, optimized m0}
 \item{mm}{numeric, optimized mm}
 \item{pp}{numeric, optimized pp}
 \item{likelihood}{numeric, the calculated likelihood}
}
}
\description{
utils_EM a function to estimate the parameters `m_0` , `mm`, `pp` through 
an Expectation-Maximization (EM) method
}
\details{
utils_EM is a tool function used in the main \code{kfino_fit} 
function. It uses the same input parameter list than the main function.
}
\examples{
set.seed(1234)
Y<-rnorm(n=10,mean=50,4)
Tps<-seq(1,10)
N=10
param2<-list(m0=41,
             mm=45,
             pp=0.5,
             aa=0.001,
             expertMin=30,
             expertMax=75,
             sigma2_m0=1,
             sigma2_mm=0.05,
             sigma2_pp=5,
             K=2,
             seqp=seq(0.5,0.7,0.1))
print(Y)
utils_EM(param=param2,kappaOpt=7,Y=Y,Tps=Tps,N=N,scalingC=6)
}
